/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.quest;

import java.util.ArrayList;
import java.util.Iterator;
import lotr.common.LOTRPlayerData;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.quest.LOTRMiniQuest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public abstract class LOTRMiniQuestCollectBase
extends LOTRMiniQuest {
    public int collectTarget;
    public int amountGiven;

    public LOTRMiniQuestCollectBase(LOTRPlayerData pd) {
        super(pd);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("Target", this.collectTarget);
        nbt.func_74768_a("Given", this.amountGiven);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.collectTarget = nbt.func_74762_e("Target");
        this.amountGiven = nbt.func_74762_e("Given");
    }

    @Override
    public boolean isValidQuest() {
        return super.isValidQuest() && this.collectTarget > 0;
    }

    @Override
    public String getQuestProgress() {
        return StatCollector.func_74837_a((String)"lotr.miniquest.collect.progress", (Object[])new Object[]{this.amountGiven, this.collectTarget});
    }

    @Override
    public String getQuestProgressShorthand() {
        return StatCollector.func_74837_a((String)"lotr.miniquest.progressShort", (Object[])new Object[]{this.amountGiven, this.collectTarget});
    }

    @Override
    public float getCompletionFactor() {
        return (float)this.amountGiven / (float)this.collectTarget;
    }

    @Override
    public void onInteract(EntityPlayer entityplayer, LOTREntityNPC npc) {
        int prevAmountGiven = this.amountGiven;
        ArrayList<Integer> slotNumbers = new ArrayList<Integer>();
        slotNumbers.add(entityplayer.field_71071_by.field_70461_c);
        for (int slot = 0; slot < entityplayer.field_71071_by.field_70462_a.length; ++slot) {
            if (slotNumbers.contains(slot)) continue;
            slotNumbers.add(slot);
        }
        Iterator slot = slotNumbers.iterator();
        while (slot.hasNext()) {
            int slot2 = (Integer)slot.next();
            ItemStack itemstack = entityplayer.field_71071_by.field_70462_a[slot2];
            if (itemstack != null && this.isQuestItem(itemstack)) {
                int amountRemaining = this.collectTarget - this.amountGiven;
                if (itemstack.field_77994_a >= amountRemaining) {
                    itemstack.field_77994_a -= amountRemaining;
                    if (itemstack.field_77994_a <= 0) {
                        itemstack = null;
                    }
                    entityplayer.field_71071_by.func_70299_a(slot2, itemstack);
                    this.amountGiven += amountRemaining;
                } else {
                    this.amountGiven += itemstack.field_77994_a;
                    entityplayer.field_71071_by.func_70299_a(slot2, null);
                }
            }
            if (this.amountGiven < this.collectTarget) continue;
            this.complete(entityplayer, npc);
            break;
        }
        if (this.amountGiven > prevAmountGiven && !this.isCompleted()) {
            this.updateQuest();
        }
        if (!this.isCompleted()) {
            this.sendProgressSpeechbank(entityplayer, npc);
        }
    }

    protected abstract boolean isQuestItem(ItemStack var1);

    @Override
    public float getAlignmentBonus() {
        float f = this.collectTarget;
        return Math.max(f *= this.rewardFactor, 1.0f);
    }

    @Override
    public int getCoinBonus() {
        return Math.round(this.getAlignmentBonus() * 2.0f);
    }
}

